<?php
// price_data.php
// This script connects to a MySQL database, retrieves price data,
// and returns the result in JSON format.

$host    = 'webdev.iyaserver.com';        
$db      = 'westongu_memecoin';   
$user    = 'westongu_guest';    
$pass    = 'acad274final';    
$charset = 'utf8mb4';

// Replace this with your table name
$table   = 'price_data';

// PDO connection settings
$dsn = "mysql:host=$host;dbname=$db;charset=$charset";
$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
];

// Set output type to JSON
header('Content-Type: application/json; charset=utf-8');


try {
    $pdo = new PDO($dsn, $user, $pass, $options);
} catch (PDOException $e) {
    echo json_encode([
        "success" => false,
        "error"   => "Database connection failed",
        "details" => $e->getMessage()
    ]);
    exit;
}


// Optional filters: ?coin_id=DOGE&ts=2024-11-25 10:00:00&date=2024-11-25
$where  = [];
$params = [];

// Filter by coin_id
if (!empty($_GET['coin_id'])) {
    $where[] = "coin_id = :coin_id";
    $params[':coin_id'] = $_GET['coin_id'];
}

// Filter by exact ts (datetime)
if (!empty($_GET['ts'])) {
    $where[] = "ts = :ts";
    $params[':ts'] = $_GET['ts'];
}

// Filter by date (date portion of ts)
if (!empty($_GET['date'])) {
    $where[] = "DATE(ts) = :date";
    $params[':date'] = $_GET['date'];
}

// Optional limit parameter
$limit = "";
if (!empty($_GET['limit']) && ctype_digit($_GET['limit'])) {
    $limit = " LIMIT " . intval($_GET['limit']);
}

// Base SQL query
$sql = "
    SELECT 
        id,
        coin_id,
        ts,
        open_price,
        high_price,
        low_price,
        close_price,
        volume_usd
    FROM $table
";

// Add WHERE conditions if needed
if (!empty($where)) {
    $sql .= " WHERE " . implode(" AND ", $where);
}

// Order by most recent timestamp first
$sql .= " ORDER BY ts DESC, coin_id ASC";
$sql .= $limit;


try {
    $stmt = $pdo->prepare($sql);
    $stmt->execute($params);
    $rows = $stmt->fetchAll();
} catch (PDOException $e) {
    echo json_encode([
        "success" => false,
        "error"   => "Query execution failed",
        "details" => $e->getMessage()
    ]);
    exit;
}


echo json_encode([
    "success" => true,
    "count"   => count($rows),
    "data"    => $rows
], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_NUMERIC_CHECK);

?>
